
<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Info Widget .
 *
 */
class Saor_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'saorcontactinfo';
	}
	public function get_title() {
		return __( 'Contact Info', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() { 

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Contact Info', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One','Style Two','Style Three'] );

		saor_general_fields($this, 'title', 'Section Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($this, 'subtitle', 'Section Sub-Title', 'TEXTAREA2', 'Default Sub-Title','2');

		$info_list = new Repeater();

		saor_general_fields($info_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($info_list, 'info', 'Info', 'TEXTAREA2', 'Default Info');
		saor_general_fields($info_list, 'icon', 'Icon', 'TEXTAREA2', 'Icon');

		$this->add_control(
			'info_list',
			[
				'label' 		=> __( 'Info List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $info_list->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['1','2','3']
				]
			]
		);


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		saor_common_style_fields( $this, '01', 'Section Title', '{{WRAPPER}} .widget_title,{{WRAPPER}} .sec-title,{{WRAPPER}} .box-title text-white', ['1','3','2'] );
		saor_common_style_fields( $this, '01a', 'Section Sub Title', '{{WRAPPER}} .widget_title,{{WRAPPER}} .sec-title,{{WRAPPER}} .text-white', ['2'] );

		saor_common_style_fields( $this, '02', 'Title', '{{WRAPPER}} .project-info_title,{{WRAPPER}} .box-title,{{WRAPPER}} .info-box_subtitle', ['1','3','2'] );
		saor_common_style_fields( $this, '03', 'Sub-Title', '{{WRAPPER}} .project-info_subtitle,{{WRAPPER}} .box-text,{{WRAPPER}} .info-box_text,{{WRAPPER}} .info-box_text a', ['1','3','2'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display(); 

			
		if($settings['layout_style'] == '1'){

            echo '<div class="widget widget_info">';
                echo '<h3 class="widget_title">'.esc_html($settings['title']).'</h3>';
                foreach( $settings['info_list'] as $key => $data ){
                echo '<div class="project-info">';
	                    echo '<div class="project-info_icon">';
	                    	 echo wp_kses_post($data['icon']);
	                    echo '</div>';
	                    echo '<div class="project-info_content">';
	                    	if(!empty($data['title'])):	
	                        	echo '<p class="project-info_subtitle">'.esc_html($data['title']).'</p>';
	                        endif;
	                        if(!empty($data['info'])):		
	                        	echo '<h6 class="project-info_title">'.esc_html($data['info']).'</h6>';
	                        endif;	
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';
		}elseif($settings['layout_style'] == '2'){
			echo '<div class="widget widget_call">';
               echo ' <div class="widget-call">';
               		if(!empty($settings['title'])):	
                    	echo '<h4 class="box-title text-white">'.esc_html($settings['title']).'</h4>';
                    endif;
                    if(!empty($settings['subtitle'])):		
                    	echo '<p class="text-white">'.esc_html($settings['subtitle']).'</p>';
                    endif;	
                    echo '<div class="widget_call">';
                    	foreach( $settings['info_list'] as $key => $data ){
	                        echo '<div class="info-box">';
	                            echo ' <div class="info-box_icon">';
	                                echo wp_kses_post($data['icon']);
	                            echo '</div>';
	                            echo '<div>';
	                                echo '<span class="info-box_subtitle">'.esc_html($data['title']).'</span>';
	                                echo '<p class="info-box_text">';
	                                    echo wp_kses_post($data['info']);
	                            echo '</p>';
	                            echo '</div>';
	                        echo '</div>';
                        }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			if(!empty($settings['title'])):	
				echo '<div class="title-area text-center">';
	                echo '<h2 class="sec-title">'.esc_html($settings['title']).'</h2>';
	            echo '</div>';
            endif;	
            echo '<div class="row gy-4">';
            	foreach( $settings['info_list'] as $key => $data ){
	                echo '<div class="col-xl-4 col-md-6">';
	                    echo '<div class="contact-media">';
	                        echo '<div class="icon-btn">';
	                            echo wp_kses_post($data['icon']);
	                        echo '</div>';
	                        echo '<div class="media-body">';
	                        	if(!empty($data['info'])):	
	                            	echo '<h5 class="box-title">'.esc_html($data['title']).'</h5>';
	                            endif;		
	                            if(!empty($data['info'])):	
	                            	echo '<p class="box-text">'.wp_kses_post($data['info']).'</p>';
	                            endif;	
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
                }
            echo '</div>';
		}
	}
       

	}