<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Faq Widget .
 *
 */
class Saor_Faq extends Widget_Base {

	public function get_name() {
		return 'saorfaq';
	}
	public function get_title() {
		return __( 'Faq', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label'		 	=> __( 'Faq', 'saor' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two'] );

        $repeater = new Repeater();

		saor_general_fields($repeater, 'faq_question', 'Faq Question', 'TEXTAREA', 'What Services Do You Offer?');
		saor_general_fields($repeater, 'faq_answer', 'Faq Answer', 'TEXTAREA', 'Ensuring safety on a construction site is crucial to protect workers');
		saor_general_fields($repeater, 'number', 'Number', 'TEXT', '01');

		$this->add_control(
			'faq_repeater',
			[
				'label' 		=> __( 'Faq Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'faq_question'    => __( 'What Services Do You Offer?', 'saor' ),
					],
				],
				'condition'		=> [ 
					'layout_style' => [ '1'],
				],
			]
		);

		$faq_repeater2 = new Repeater();

		saor_general_fields($faq_repeater2, 'faq_question', 'Faq Question', 'TEXTAREA', 'What Services Do You Offer?');
		saor_general_fields($faq_repeater2, 'faq_answer', 'Faq Answer', 'TEXTAREA', 'Ensuring safety on a construction site is crucial to protect workers');

		$this->add_control(
			'faq_repeater2',
			[
				'label' 		=> __( 'Faq Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $faq_repeater2->get_controls(),
				'default' 		=> [
					[
						'faq_question'    => __( 'What Services Do You Offer?', 'saor' ),
					],
				],
				'condition'		=> [ 
					'layout_style' => ['2'],
				],
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//--------------------------------------- 

		//------Menu Bar Style-------
        $this->start_controls_section(
			'faq_styling',
			[
				'label'     => __( 'Faq Styling', 'saor' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		saor_general_fields( $this, 'hr', 'Question Style', 'HEADING', '' );
		saor_color_fields( $this, 'title_color', 'Color', 'color', '{{WRAPPER}} .accordion-button' );
		saor_typography_fields( $this, 'title_font', 'Trpography', '{{WRAPPER}} .accordion-button' );
		saor_general_fields( $this, 'hr2', 'Answer Style', 'HEADING', '' );
		saor_color_fields( $this, 'contnet_color', 'Color', 'color', '{{WRAPPER}} .accordion-body, {{WRAPPER}} p' );
		saor_typography_fields( $this, 'contnet_font', 'Trpography', '{{WRAPPER}} .accordion-body, {{WRAPPER}} p' );

		$this->end_controls_section();

		//-------Title Style-------


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if($settings['layout_style'] == '1'){
            $counter = 1;
	        echo '<div class="accordion-area accordion style2" id="faqAccordion">';
	        	foreach( $settings['faq_repeater'] as $key => $single_data ){
	        		if($counter == '2'){
						$class = esc_attr__("show");
					}else{
						$class = esc_attr__("");
					}

					if($counter == '2'){
						$active = esc_attr__("active");
					}else{
						$active = esc_attr__("");
					}

					if($counter == '2'){
						$btn_class = esc_attr__("");
					}else{
						$btn_class = esc_attr__("collapsed");
					}
	        		echo '<div class="accordion-wrapp">';
	        			if(!empty($single_data['number'])){
	        				echo '<span class="number">'.wp_kses_post($single_data['number']).'</span>';
	        			}
	                    echo '<div class="accordion-card style2 '.$active.'">';
	                        echo '<div class="accordion-header" id="collapse-item-'.esc_attr($counter).'">';
	                            echo '<button class="accordion-button '.$btn_class.'" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-'.esc_attr($counter).'" aria-expanded="true" aria-controls="collapse-'.esc_attr($counter).'">'.wp_kses_post($single_data['faq_question']).'</button>';
	                        echo '</div>';
	                        echo '<div id="collapse-'.esc_attr($counter).'" class="accordion-collapse collapse '.$class.'" aria-labelledby="collapse-item-'.esc_attr($counter).'" data-bs-parent="#faqAccordion">';
	                            echo '<div class="accordion-body">';
	                                echo '<p class="faq-text">'.wp_kses_post($single_data['faq_answer']).'</p>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	                $counter++;
	            }    
            echo '</div>';
		}elseif($settings['layout_style'] == '2'){

			echo '<div class="accordion-area accordion" id="faqAccordion">';
				$counter = 1;
				foreach( $settings['faq_repeater2'] as $key => $single_data ){
        		if($counter == '2'){
					$class = esc_attr__("show");
				}else{
					$class = esc_attr__("");
				}

				if($counter == '2'){
					$active = esc_attr__("active");
				}else{
					$active = esc_attr__("");
				}

				if($counter == '2'){
					$btn_class = esc_attr__("");
				}else{
					$btn_class = esc_attr__("collapsed");
				}
	                echo '<div class="accordion-card '.$active.'">';
	                    echo '<div class="accordion-header" id="collapse-item-'.esc_attr($counter).'">';
	                        echo '<button class="accordion-button '.$btn_class.'" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-'.esc_attr($counter).'" aria-expanded="false" aria-controls="collapse-'.esc_attr($counter).'">'.wp_kses_post($single_data['faq_question']).'</button>';
	                    echo '</div>';
	                    echo '<div id="collapse-'.esc_attr($counter).'" class="accordion-collapse collapse '.$class.'" aria-labelledby="collapse-item-'.esc_attr($counter).'" data-bs-parent="#faqAccordion">';
	                        echo '<div class="accordion-body">';
	                            echo '<p class="faq-text">'.wp_kses_post($single_data['faq_answer']).'</p>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            $counter++;
	            }        
			echo '</div>';
		}
		
	

	}
}