<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class Saor_Footer_Copyright extends Widget_Base{

	public function get_name() {
		return 'saor_footer_copyright';
	}
	public function get_title() {
		return esc_html__( 'Footer Copyright', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'footer_copyright_content',
			[
				'label'		=> esc_html__( 'Footer Copyright','saor' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two' ] );

		saor_general_fields($this, 'title', 'Title', 'TEXTAREA', 'Title');

		$footer_nav_menu = new \Elementor\Repeater();

		$footer_nav_menu->add_control(
		    'nav_menu',
		    [
		        'label' => __('Select Nav Menu', 'ploming-addon'),
		        'type' => \Elementor\Controls_Manager::SELECT2,
		        'options' => saor_get_nav_menu(),
		        'label_block' => true,
		    ]
		);

		$this->add_control(
		    'footer_nav_menu',
		    [
		        'label' => __('Nav Menus', 'ploming-addon'),
		        'type' => \Elementor\Controls_Manager::REPEATER,
		        'fields' => $footer_nav_menu->get_controls(),
		        'prevent_empty' => false,
		    ]
		);


		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		saor_common_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title'  );
		saor_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .box-desig' );

	}

	public function saor_menu_select(){ 
	    $saor_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'saor' );
	    foreach( $saor_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

	$settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){

	        echo '<div class="copyright-wrap">';
	            echo '<div class="container">';
	                echo '<div class="row gy-2 align-items-center justify-content-between">';
	                   echo '<div class="col-md-6">';
	                        echo '<p class="copyright-text">'.wp_kses_post($settings['title']).'</p>';
	                    echo '</div>';
	                    echo '<div class="col-md-6 text-center text-md-end">';
	                        echo '<div class="footer-links">';
					            foreach ($settings['footer_nav_menu'] as $nav_menu) : 
					                wp_nav_menu(array(
					                    'menu' => $nav_menu['nav_menu'],
					                ));
					                
					            endforeach;
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';


		}
		
		
	}
}