<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * mission Widget .
 *
 */
class Saor_Mission extends Widget_Base {

	public function get_name() {
		return 'saormission';
	}
	public function get_title() {
		return __( 'Mission', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Mission', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ] ); 

        saor_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($this, 'subtitle', 'Subtitle', 'TEXTAREA2', 'Default Subtitle');
        saor_general_fields($this, 'summary', 'Summary', 'TEXTAREA2', 'Default Summary');
        saor_url_fields($this, 'url', 'URL');

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
        //-------Title Style-------
        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title' );
        //------Button Style (gradient-color)-------
        saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn' );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

            echo '<div class="project-card">';
                echo '<span class="box-subtitle">'.esc_html($settings['subtitle']).'</span>';
                echo '<h3 class="box-title"><a href="'.esc_url($settings['url']['url']).'">'.esc_html($settings['title']).'</a></h3>';
                echo '<p class="box-text">'.esc_html($settings['summary']).'</p>';
            echo '</div>';

		}

	
	}

}