<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Progres Widget .
 *
 */
class Saor_Progres_Bar extends Widget_Base {

	public function get_name() {
		return 'saor_progress_bar';
	}
	public function get_title() {
		return __( 'Progress Bar', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Progres', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] ); 

        $progres_bar_list = new Repeater();

        saor_general_fields($progres_bar_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($progres_bar_list, 'number', 'Number', 'TEXT', '12');

        $progres_bar_list->add_control(
            'shape_color',
            [
                'label' => esc_html__('Shape Color', 'kidearn-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => __('#087CEB', 'kidearn-addon'),
            ]
        );
    
        $this->add_control(
            'progres_bar_list',
            [
                'label'         => __( 'Progres List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $progres_bar_list->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['1']
                ]
            ]
        );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
        //-------Title Style-------
        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .skill-feature_title' );
        //------Button Style (gradient-color)-------
        saor_button_style_fields( $this, '10', 'Button Styling', '{{WRAPPER}} .th_btn' );


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1'){

            echo '<div class="skill-card mt-30">';
                foreach( $settings['progres_bar_list'] as $key => $data ){
                    echo '<div class="skill-feature" data-theme-color="'.esc_attr($data['shape_color']).'">';
                        if(!empty($data['title'])):
                            echo '<h5 class="skill-feature_title">'.esc_html($data['title']).'</h5>';
                        endif;    
                        echo '<div class="progress">';
                            echo '<div class="progress-bar" style="width: '.esc_attr($data['number']).';">';
                                echo '<div class="progress-value">'.esc_html($data['number']).'</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';
        }

	
	}

}