<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * gallery Widget .
 *
 */
class Saor_Project extends Widget_Base {

	public function get_name() {
		return 'saorproject';
	}
	public function get_title() {
		return __( 'Project', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'project_section',
			[
				'label'     => __( 'Project Content', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four'] );
		saor_general_fields($this, 'cat_title', 'Title', 'TEXTAREA2', 'All Works',['2']);

		$gallery_list = new Repeater();

		saor_general_fields($gallery_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($gallery_list, 'subtitle', 'Sub-Title', 'TEXTAREA2', 'Default Sub-Title');
		saor_media_fields($gallery_list, 'image', 'Gallery Image');
		saor_url_fields($gallery_list, 'url', 'URL');
		saor_general_fields($gallery_list, 'arrow_icon', 'Icon', 'TEXT', '<i class="fa-sharp fa-regular fa-arrow-right"></i>');
		
		$this->add_control(
			'gallery_list',
			[
				'label' 		=> __( 'Gallery List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $gallery_list->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1','4']
				]
			]
		);

		$category_list = new Repeater();

		saor_general_fields($category_list, 'name', 'Caegory Name', 'TEXTAREA2', 'Name');
		saor_general_fields($category_list, 'slug', 'Caegory Slug', 'TEXTAREA2', 'Slug');
		
		$this->add_control(
			'category_list',
			[
				'label' 		=> __( 'Category List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $category_list->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Category List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$gallery_list2 = new Repeater();

		saor_general_fields($gallery_list2, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($gallery_list2, 'subtitle', 'Sub-Title', 'TEXTAREA2', 'Default Sub-Title');
		saor_general_fields($gallery_list2, 'category', 'Category', 'TEXTAREA2', 'Category');
		saor_media_fields($gallery_list2, 'image', 'Gallery Image');
		saor_url_fields($gallery_list2, 'url', 'URL');
		saor_general_fields($gallery_list2, 'arrow_icon', 'Icon', 'TEXT', '<i class="fa-sharp fa-regular fa-arrow-right"></i>');
		
		$this->add_control(
			'gallery_list2',
			[
				'label' 		=> __( 'Gallery List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $gallery_list2->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);


		$gallery_list3 = new Repeater();

		saor_general_fields($gallery_list3, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_general_fields($gallery_list3, 'subtitle', 'Sub-Title', 'TEXTAREA2', 'Default Sub-Title');
		saor_media_fields($gallery_list3, 'image', 'Gallery Image');
		saor_url_fields($gallery_list3, 'url', 'URL');
		
		$this->add_control(
			'gallery_list3',
			[
				'label' 		=> __( 'Gallery List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $gallery_list3->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Title', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);

		saor_general_fields($this, 'button_label', 'Button Label', 'TEXTAREA2', 'Button Label', ['2'] );
		saor_url_fields( $this, 'button_url', 'URL', [ '2']  );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Name Style-------
		saor_common2_style_fields( $this, '01', 'Title', '{{WRAPPER}} .project-grid .box-title a,{{WRAPPER}} .box-title a' );
		//-------Designation Style-------
		saor_common_style_fields( $this, '02', 'Subtitle', '{{WRAPPER}} .box-subtitle' );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

			if($settings['layout_style'] == '1'){
	            echo '<div class="row gx-80">';
	                foreach( $settings['gallery_list'] as $data ){
		                echo '<div class="col-md-6 project-box_wrapp">';
		                    echo '<div class="project-box">';
		                        echo '<div class="box-img global-img">';
		                            echo saor_img_tag( array(
										'url'   => esc_url( $data['image']['url']  ),
									));
		                        echo '</div>';
		                        echo '<div class="box-wrapp">';
		                            echo '<div class="project-content">';
		                            	if(!empty($data['subtitle'])){ 
		                                	echo '<p class="box-subtitle">'.esc_html($data['subtitle']).'</p>';
		                                }
		                                if(!empty($data['title'])){ 
		                                	echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }	
		                            echo '</div>';
		                            if(!empty($data['arrow_icon'])){
		                            	echo '<span class="icon">'. wp_kses_post( $data['arrow_icon'] ).'</span>';
		                            }		
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
		        echo '</div>';     
			}elseif($settings['layout_style'] == '2'){

				echo '<div class="filter-menu filter-menu-active">';
	                echo '<button data-filter="*" class="tab-btn active" type="button">'.esc_html($settings['cat_title']).'</button>';
	                foreach( $settings['category_list'] as $data ){	
	                	echo '<button data-filter=".'.esc_html($data['slug']).'" class="tab-btn" type="button">'.esc_html($data['name']).'</button>';
	              	}
	            echo '</div>';
	            echo '<div class="portfolio-area">';
	                echo '<div class="row gy-4  filter-active">';
	                	foreach( $settings['gallery_list2'] as $data ){
		                    echo '<div class="col-md-6 col-xl-auto filter-item '. wp_kses_post( $data['category'] ).'">';
		                        echo '<div class="project-item">';
		                            echo '<div class="box-img global-img">';
		                                echo saor_img_tag( array(
											'url'   => esc_url( $data['image']['url']  ),
										));
		                            echo ' </div>';
		                            echo '<div class="box-content">';
	                               		if(!empty($data['title'])){ 
		                                	echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }
		                                if(!empty($data['subtitle'])){ 
		                                	echo '<p class="box-subtitle">'.esc_html($data['subtitle']).'</p>';
		                                }
		                            echo ' </div>';
		                            if(!empty($data['image']['url'])){ 
		                            	echo '<div class="box-btn"><a href="'.esc_url( $data['url']['url'] ).'" class="icon-btn popup-image">'. wp_kses_post( $data['arrow_icon'] ).'</a></div>';
		                            }	
		                        echo '</div>';
		                    echo '</div>';
	                    }
	                echo '</div>';
	                if(!empty($settings['button_label'])){ 
	                	echo '<div class="project-btn mt-60"><a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn th-radius">'.esc_html($settings['button_label']).'</a>';
	                }	
	                echo '</div>';
	            echo '</div>';

			}elseif($settings['layout_style'] == '3'){

				echo '<div class="row gy-4 filter-active">';
					foreach( $settings['gallery_list3'] as $data ){
		                echo '<div class="col-md-6 col-xxl-auto filter-item">';
		                    echo '<div class="project-grid">';
		                        echo '<div class="project-img">';
		                            echo saor_img_tag( array(
										'url'   => esc_url( $data['image']['url']  ),
									));
		                        echo '</div>';
		                        echo '<div class="project-content">';
		                            if(!empty($data['title'])){ 
	                                	echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
	                                }
	                                if(!empty($data['subtitle'])){ 
	                                	echo '<p class="box-subtitle">'.esc_html($data['subtitle']).'</p>';
	                                }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }    
	            echo '</div>';

			}elseif($settings['layout_style'] == '4'){
	            echo '<div class="row gx-80">';
	                foreach( $settings['gallery_list'] as $data ){
		                echo '<div class="col-md-6 project-box_wrapp">';
		                    echo '<div class="project-box style2">';
		                        echo '<div class="box-img global-img">';
		                            echo saor_img_tag( array(
										'url'   => esc_url( $data['image']['url']  ),
									));
		                        echo '</div>';
		                        echo '<div class="box-wrapp">';
		                            echo '<div class="project-content">';
		                            	if(!empty($data['subtitle'])){ 
		                                	echo '<p class="box-subtitle">'.esc_html($data['subtitle']).'</p>';
		                                }
		                                if(!empty($data['title'])){ 
		                                	echo '<h3 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
		                                }	
		                            echo '</div>';
		                            if(!empty($data['arrow_icon'])){
		                            	echo '<span class="icon">'. wp_kses_post( $data['arrow_icon'] ).'</span>';
		                            }		
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
		        echo '</div>';     
			}
			
	}
}