<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Widget .
 *
 */
class Saor_Team extends Widget_Base {

	public function get_name() {
		return 'saorteam';
	}
	public function get_title() {
		return __( 'Team', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label'     => __( 'Team Content', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Three'] );

		$repeater = new Repeater();

		saor_media_fields($repeater, 'team_image', 'Team Image');
		saor_general_fields($repeater, 'name', 'Name', 'TEXTAREA2', 'John Simon');
		saor_url_fields($repeater, 'profile_url', 'Profile URL');
		saor_general_fields($repeater, 'designation', 'Designation', 'TEXTAREA2', 'Best Technician of Office Repair and Maintenance');
		saor_general_fields($repeater, 'social', 'Social', 'TEXTAREA', 'Social');
		
		$this->add_control(
			'team_lists',
			[
				'label' 		=> __( 'Member Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'John Simon', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1','2','3','4']
				]
			]
		);

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Name Style-------
		saor_common2_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title a' );
		//-------Designation Style-------
		saor_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .team-desig' );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

			if( $settings['layout_style'] == '1' ){

	            echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider teamSlider2 has-shadow" id="teamSlider2" data-slider-options=\'{"spaceBetween":80,"breakpoints":{"0":{"slidesPerView":1},"767":{"slidesPerView":"2"},"992":{"slidesPerView":"2","centeredSlides":"true"},"1024":{"slidesPerView":"3","centeredSlides":"true"}}}\'>';
	                    echo '<div class="swiper-wrapper">';
	                    	foreach( $settings['team_lists'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="th-team team-box">';
		                                echo '<div class="team-img-wrap">';
		                                    echo '<div class="box-img">';
		                                        echo saor_img_tag( array(
													'url'   => esc_url( $data['team_image']['url']  ),
												));
		                                    echo '</div>';
		                                    if(!empty($data['social'])){	
			                                    echo '<div class="th-social">';
			                                        echo wp_kses_post($data['social']);
			                                    echo '</div>';
			                                }    
		                                echo '</div>';
		                                echo '<div class="box-content">';
			                                if($data['name']){
			                                	echo '<h3 class="box-title"><a href="'.esc_url($data['profile_url']['url']).'">'.esc_html($data['name']).'</a></h3>';
			                                }
		                                    if($data['designation']){	
			                                	echo '<span class="team-desig">'.esc_html($data['designation']).'</span>';
			                            	}
		                                echo '</div>';

		                            echo '</div>';
		                        echo '</div>';
		                    }    
	                    echo ' </div>';
	                    echo '<div class="icon-box">';
	                        echo '<button data-slider-prev="#teamSlider2" class="slider-arrow default"><i class="far fa-arrow-left"></i></button>';
	                        echo '<button data-slider-next="#teamSlider2" class="slider-arrow default"><i class="far fa-arrow-right"></i></button>';
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';

			}elseif($settings['layout_style'] == '2'){

				echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider has-shadow" id="teamSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"}}}\'>';
	                    echo '<div class="swiper-wrapper">';
	                    	foreach( $settings['team_lists'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="th-team team-grid">';
		                                echo '<div class="team-img">';
	                                     	echo saor_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                    if(!empty($data['social'])){	
			                                    echo '<div class="th-social">';
			                                        echo wp_kses_post($data['social']);
			                                    echo '</div>';
			                                } 
		                                echo '</div>';
	                               		if($data['name']){
		                                	echo '<h3 class="box-title"><a href="'.esc_url($data['profile_url']['url']).'">'.esc_html($data['name']).'</a></h3>';
		                                }
	                                    if($data['designation']){	
		                                	echo '<span class="team-desig">'.esc_html($data['designation']).'</span>';
		                            	}
		                            echo '</div>';
		                        echo '</div>';
		                    }    
	                    echo '</div>';
	                echo '</div>';

	            echo '</div>';
			}elseif($settings['layout_style'] == '3'){
				echo '<div class="slider-area">';
	                echo '<div class="swiper th-slider has-shadow" id="teamSlider1" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
	                    echo '<div class="swiper-wrapper">';
	                    	foreach( $settings['team_lists'] as $data ){
		                        echo '<div class="swiper-slide">';
		                           echo ' <div class="th-team team-card">';
		                                echo '<div class="box-img">';
		                                    echo saor_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                echo '</div>';
		                                echo '<div class="box-content">';
		                                    echo '<div>';
		                                        if($data['name']){
				                                	echo '<h3 class="box-title"><a href="'.esc_url($data['profile_url']['url']).'">'.esc_html($data['name']).'</a></h3>';
				                                }
			                                    if($data['designation']){	
				                                	echo '<span class="team-desig">'.esc_html($data['designation']).'</span>';
				                            	}
		                                    echo '</div>';
		                                    if(!empty($data['social'])){	
			                                    echo '<div class="team-social">';
			                                        echo '<div class="icon-btn"><i class="fa-light fa-plus"></i></div>';
			                                        echo '<div class="th-social">';
			                                              echo wp_kses_post($data['social']);
			                                        echo '</div>';
			                                    echo '</div>';
			                                }    
		                                echo '</div>';

		                            echo '</div>';
		                        echo '</div>';
		                    }    
	                    echo '</div>';
	                echo '</div>';
	                echo '<button data-slider-prev="#teamSlider1" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
	                echo '<button data-slider-next="#teamSlider1" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
	            echo '</div>';

			}elseif($settings['layout_style'] == '4'){
				echo '<div class="row gy-40">';
					foreach( $settings['team_lists'] as $data ){
		                echo '<div class="col-xl-4 col-xxl-3 col-md-6">';
		                    echo '<div class="th-team team-card style2">';
		                        echo '<div class="box-img">';
		                            echo saor_img_tag( array(
										'url'   => esc_url( $data['team_image']['url']  ),
									));
		                        echo '</div>';
		                        echo '<div class="box-content">';
			                        echo '<div>';
		                               	if($data['name']){
		                                	echo '<h3 class="box-title"><a href="'.esc_url($data['profile_url']['url']).'">'.esc_html($data['name']).'</a></h3>';
		                                }
		                                if($data['designation']){	
		                                	echo '<span class="team-desig">'.esc_html($data['designation']).'</span>';
		                            	}
	                            	echo ' </div>';
		                            if(!empty($data['social'])){
			                            echo '<div class="team-social">';
			                                echo '<div class="icon-btn"><i class="fa-light fa-plus"></i></div>';
			                                echo '<div class="th-social">';
			                                    echo wp_kses_post($data['social']);
			                                echo '</div>';
			                            echo '</div>';
		                            }
		                        echo '</div>';    
		                    echo '</div>';
		                echo '</div>';
   					}
	            echo '</div>';
			}
	
			
	}
}