<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class Saor_Video extends Widget_Base {

	public function get_name() {
		return 'saorvideo';
	}
	public function get_title() {
		return __( 'Video Box', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] ); 

		saor_media_fields( $this, 'image1', 'Choose Image One', [ '1'] );
		saor_general_fields( $this, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-regular fa-play"></i>','1' );
		saor_url_fields( $this, 'video_url', 'Video URL','1' );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		saor_common_style_fields($this, '04', 'Title', '{{WRAPPER}} .sec-title', ['2', '3', '4'] );
		saor_common_style_fields($this, '05', 'Description', '{{WRAPPER}} .sec-text', ['3', '4'] );
		//-------Number Style-------
		saor_common_style_fields($this, '01', 'Number', '{{WRAPPER}} .box-number .counter-number', ['2', '3', '4'] );
		saor_common_style_fields($this, '02', 'Number Prefix', '{{WRAPPER}} .box-number', ['2', '3', '4']);
		//-------Title Style-------
		saor_common_style_fields($this, '03', 'Content', '{{WRAPPER}} .box-text', ['2', '3', '4']);
	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1'){
            if(!empty($settings['video_url']['url'])){
            echo '<div class="choose-wrapper">';	
	            echo '<div class="video-box1">';
	            	echo saor_img_tag( array(
						'url'   => esc_url( $settings['image1']['url'] ),
					));
	            	if($settings['video_url']['url']){
	                	echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
	                }	
	            echo '</div>';
	        echo '</div>';
	        }
		}


	}

}