<?php
    /**
     * Class For Builder
     */
    class saorBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'saor_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'saor-core',SAOR_PLUGDIRURI.'assets/js/saor-core.js',array( 'jquery' ),'1.0',true );
		}


        public function saor_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'saor_header_option',
                [
                    'label'     => __( 'Header Option', 'saor' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'saor_header_style',
                [
                    'label'     => __( 'Header Option', 'saor' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'saor' ),
    					'header_builder'       => __( 'Header Builder', 'saor' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'saor_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'saor' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->saor_header_choose_option(),
                    'condition' => [ 'saor_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'saor_footer_option',
                [
                    'label'     => __( 'Footer Option', 'saor' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'saor_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'saor' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'saor' ),
    				'label_off'     => __( 'No', 'saor' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'saor_footer_style',
                [
                    'label'     => __( 'Footer Style', 'saor' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'saor' ),
    					'footer_builder'       => __( 'Footer Builder', 'saor' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'saor_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'saor_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'saor' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->saor_footer_build_choose_option(),
                    'condition' => [ 'saor_footer_style' => 'footer_builder','saor_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Saor Builder', 'saor' ),
            	esc_html__( 'Saor Builder', 'saor' ),
				'manage_options',
				'saor',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('saor', esc_html__('Footer Builder', 'saor'), esc_html__('Footer Builder', 'saor'), 'manage_options', 'edit.php?post_type=saor_footerbuild');
			add_submenu_page('saor', esc_html__('Header Builder', 'saor'), esc_html__('Header Builder', 'saor'), 'manage_options', 'edit.php?post_type=saor_header');
			add_submenu_page('saor', esc_html__('Tab Builder', 'saor'), esc_html__('Tab Builder', 'saor'), 'manage_options', 'edit.php?post_type=saor_tab_builder');
			add_submenu_page('saor', esc_html__('Megamenu', 'saor'), esc_html__('Megamenu', 'saor'), 'manage_options', 'edit.php?post_type=saor_megamenu');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header , Footer  And Megamenu Builder Of This Theme','saor' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'saor' ),
				'singular_name'      => __( 'Footer', 'saor' ),
				'menu_name'          => __( 'saor Footer Builder', 'saor' ),
				'name_admin_bar'     => __( 'Footer', 'saor' ),
				'add_new'            => __( 'Add New', 'saor' ),
				'add_new_item'       => __( 'Add New Footer', 'saor' ),
				'new_item'           => __( 'New Footer', 'saor' ),
				'edit_item'          => __( 'Edit Footer', 'saor' ),
				'view_item'          => __( 'View Footer', 'saor' ),
				'all_items'          => __( 'All Footer', 'saor' ),
				'search_items'       => __( 'Search Footer', 'saor' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'saor' ),
				'not_found'          => __( 'No Footer found.', 'saor' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'saor' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'saor_footerbuild', $args );

			$labels = array(
				'name'               => __( 'Header', 'saor' ),
				'singular_name'      => __( 'Header', 'saor' ),
				'menu_name'          => __( 'saor Header Builder', 'saor' ),
				'name_admin_bar'     => __( 'Header', 'saor' ),
				'add_new'            => __( 'Add New', 'saor' ),
				'add_new_item'       => __( 'Add New Header', 'saor' ),
				'new_item'           => __( 'New Header', 'saor' ),
				'edit_item'          => __( 'Edit Header', 'saor' ),
				'view_item'          => __( 'View Header', 'saor' ),
				'all_items'          => __( 'All Header', 'saor' ),
				'search_items'       => __( 'Search Header', 'saor' ),
				'parent_item_colon'  => __( 'Parent Header:', 'saor' ),
				'not_found'          => __( 'No Header found.', 'saor' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'saor' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'saor_header', $args );

			$labels = array(
				'name'               => __( 'Tab Builder', 'saor' ),
				'singular_name'      => __( 'Tab Builder', 'saor' ),
				'menu_name'          => __( 'Gesund Tab Builder', 'saor' ),
				'name_admin_bar'     => __( 'Tab Builder', 'saor' ),
				'add_new'            => __( 'Add New', 'saor' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'saor' ),
				'new_item'           => __( 'New Tab Builder', 'saor' ),
				'edit_item'          => __( 'Edit Tab Builder', 'saor' ),
				'view_item'          => __( 'View Tab Builder', 'saor' ),
				'all_items'          => __( 'All Tab Builder', 'saor' ),
				'search_items'       => __( 'Search Tab Builder', 'saor' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'saor' ),
				'not_found'          => __( 'No Tab Builder found.', 'saor' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'saor' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'saor_tab_builder', $args );


			$labels = array(
				'name'               => __( 'Megamenu', 'saor' ),
				'singular_name'      => __( 'Megamenu', 'saor' ),
				'menu_name'          => __( 'saor Megamenu', 'saor' ),
				'name_admin_bar'     => __( 'Megamenu', 'saor' ),
				'add_new'            => __( 'Add New', 'saor' ),
				'add_new_item'       => __( 'Add New Megamenu', 'saor' ),
				'new_item'           => __( 'New Megamenu', 'saor' ),
				'edit_item'          => __( 'Edit Megamenu', 'saor' ),
				'view_item'          => __( 'View Megamenu', 'saor' ),
				'all_items'          => __( 'All Megamenu', 'saor' ),
				'search_items'       => __( 'Search Megamenu', 'saor' ),
				'parent_item_colon'  => __( 'Parent Megamenu:', 'saor' ),
				'not_found'          => __( 'No Megamenu found.', 'saor' ),
				'not_found_in_trash' => __( 'No Megamenu found in Trash.', 'saor' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'saor_megamenu', $args );
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'saor_footerbuild' == $post->post_type || 'saor_header' == $post->post_type || 'saor_tab_build' == $post->post_type || 'saor_megamenu' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function saor_footer_build_choose_option(){

			$saor_post_query = new WP_Query( array(
				'post_type'			=> 'saor_footerbuild',
				'posts_per_page'	    => -1,
			) );

			$saor_builder_post_title = array();
			$saor_builder_post_title[''] = __('Select a Footer','saor');

			while( $saor_post_query->have_posts() ) {
				$saor_post_query->the_post();
				$saor_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $saor_builder_post_title;

		}

		public function saor_header_choose_option(){

			$saor_post_query = new WP_Query( array(
				'post_type'			=> 'saor_header',
				'posts_per_page'	    => -1,
			) );

			$saor_builder_post_title = array();
			$saor_builder_post_title[''] = __('Select a Header','saor');

			while( $saor_post_query->have_posts() ) {
				$saor_post_query->the_post();
				$saor_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $saor_builder_post_title;

        }

    }

    $builder_execute = new saorBuilder();