<?php
/**
 * 
 * Plugin Name: Saor Core
 * Description: This is a helper plugin of saor theme
 * Version:     1.0
 * Author:      Themeholy
 * Author URI:  https://themeforest.net/user/themeholy 
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: saor
 * 
 */

// Blocking direct access

if( ! defined( 'ABSPATH' ) ) {

    exit();

}

// Define Constant

define( 'SAOR_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

define( 'SAOR_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'SAOR_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );

define( 'SAOR_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );

define( 'SAOR_PLUGDIRURI', plugin_dir_url( __FILE__ ) );

define( 'SAOR_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );

define( 'SAOR_ELEMENTOR_OPTIONS', plugin_dir_url( __FILE__ ) .'addons/elementor-options/' );

define( 'SAOR_ASSETS', plugin_dir_url( __FILE__ ) .'assets/' );

define( 'SAOR_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'saor-template/' );

// load textdomain

function saor_text_domain() {
	add_action('init', function()
	{
	    load_plugin_textdomain('saor_text_domain', false, basename( dirname( _FILE_ ) ) . '/languages');
	});	
}
add_action('init', 'saor_text_domain');


//include file.

require_once SAOR_PLUGIN_INC_PATH .'saorcore-functions.php';
require_once SAOR_PLUGIN_INC_PATH .'builder/builder.php';
require_once SAOR_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once SAOR_PLUGIN_INC_PATH .'saorajax.php';
require_once SAOR_PLUGIN_INC_PATH .'megamenu.php';

require_once SAOR_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget

require_once SAOR_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
require_once SAOR_PLUGIN_WIDGET_PATH . 'search-form.php';
require_once SAOR_PLUGIN_WIDGET_PATH . 'categories-lists.php';
require_once SAOR_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
require_once SAOR_PLUGIN_WIDGET_PATH . 'saor-newslater-widget.php';
// require_once SAOR_PLUGIN_WIDGET_PATH . 'author-widget.php';
require_once SAOR_PLUGIN_WIDGET_PATH . 'offer-banner.php';
// require_once SAOR_PLUGIN_WIDGET_PATH . 'saor-contact-author.php';

//addons

require_once SAOR_ADDONS . 'addons.php';
require_once SAOR_ADDONS . 'addons-style-functions.php';
require_once SAOR_ADDONS . 'addons-field-functions.php';

// Register widget styles
add_action( 'elementor/editor/after_enqueue_scripts', 'widget_styles' );

function widget_styles() {

    wp_register_style( 'editor-style-1', plugins_url( 'assets/css/editor.css', __FILE__ ) );
    wp_enqueue_style( 'editor-style-1' );

}


