<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// enqueue css
function saor_common_custom_css(){
	wp_enqueue_style( 'saor-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = saor_opt( 'saor_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";
    
    if( get_header_image() ){
        $saor_header_bg =  get_header_image();
    }else{
        if( saor_meta( 'page_breadcrumb_settings' ) == 'page' ){
            if( ! empty( saor_meta( 'breadcumb_image' ) ) ){
                $saor_header_bg = saor_meta( 'breadcumb_image' );
            }
        }
    }
    
    if( !empty( $saor_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$saor_header_bg}')!important;
        }";
    }
    
	// Theme color
	$saorthemecolor = saor_opt('saor_theme_color'); 
    if( !empty( $saorthemecolor ) ){
        list($r, $g, $b) = sscanf( $saorthemecolor, "#%02x%02x%02x");

        $saor_real_color = $r.','.$g.','.$b;
        if( !empty( $saorthemecolor ) ) {
            $customcss .= ":root {
            --theme-color: rgb({$saor_real_color});
            }";
        }
    }
    // Heading  color
	$saorheadingcolor = saor_opt('saor_heading_color');
    if( !empty( $saorheadingcolor ) ){
        list($r, $g, $b) = sscanf( $saorheadingcolor, "#%02x%02x%02x");

        $saor_real_color = $r.','.$g.','.$b;
        if( !empty( $saorheadingcolor ) ) {
            $customcss .= ":root {
                --title-color: rgb({$saor_real_color});
            }";
        }
    }
    // Body color
	$saorbodycolor = saor_opt('saor_body_color');
    if( !empty( $saorbodycolor ) ){
        list($r, $g, $b) = sscanf( $saorbodycolor, "#%02x%02x%02x");

        $saor_real_color = $r.','.$g.','.$b;
        if( !empty( $saorbodycolor ) ) {
            $customcss .= ":root {
                --body-color: rgb({$saor_real_color});
            }";
        }
    }

     // Body font
     $saorbodyfont = saor_opt('saor_theme_body_font', 'font-family');
     if( !empty( $saorbodyfont ) ) {
         $customcss .= ":root {
             --body-font: $saorbodyfont ;
         }";
     }
 
     // Heading font
     $saorheadingfont = saor_opt('saor_theme_heading_font', 'font-family');
     if( !empty( $saorheadingfont ) ) {
         $customcss .= ":root {
             --title-font: $saorheadingfont ;
         }";
     }


    if(saor_opt('saor_menu_icon_class')){
        $menu_icon_class = saor_opt( 'saor_menu_icon_class' );
    }else{
        $menu_icon_class = 'e00d';
    }

    if( !empty( $menu_icon_class ) ) {
        $customcss .= ":root {
            .main-menu ul.sub-menu li a:before {
                content: \"\\$menu_icon_class\";
            }
        }";
    }

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'saor-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'saor_common_custom_css', 100 );