<?php
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $saor_post_id = get_the_ID();

            // Get the page settings manager
            $saor_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $saor_page_settings_model = $saor_page_settings_manager->get_model( $saor_post_id );

            // Retrieve the color we added before
            $saor_header_style = $saor_page_settings_model->get_settings( 'saor_header_style' );
            $saor_header_builder_option = $saor_page_settings_model->get_settings( 'saor_header_builder_option' );

            if( $saor_header_style == 'header_builder'  ) {

                if( !empty( $saor_header_builder_option ) ) {
                    $saorheader = get_post( $saor_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $saorheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $saor_header_builder_trigger = saor_opt('saor_header_options');
                if( $saor_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $saor_global_header_select = get_post( saor_opt( 'saor_header_select_options' ) );
                    $header_post = get_post( $saor_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    saor_global_header_option();
                }
            }
        } else {
            $saor_header_options = saor_opt('saor_header_options');
            if( $saor_header_options == '1' ) {
                saor_global_header_option();
            } else {
                $saor_header_select_options = saor_opt('saor_header_select_options');
                $saorheader = get_post( $saor_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $saorheader->ID );
                echo '</header>';
            }
        }
    } else {
        saor_global_header_option();
    }